/*
	File:		main.c
	
	Description: Main program

	Author:		QuickTime team

	Copyright: 	 Copyright 1999 Apple Computer, Inc. All rights reserved.
	
	Disclaimer:	IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
				("Apple") in consideration of your agreement to the following terms, and your
				use, installation, modification or redistribution of this Apple software
				constitutes acceptance of these terms.  If you do not agree with these terms,
				please do not use, install, modify or redistribute this Apple software.

				In consideration of your agreement to abide by the following terms, and subject
				to these terms, Apple grants you a personal, non-exclusive license, under Apples
				copyrights in this original Apple software (the "Apple Software"), to use,
				reproduce, modify and redistribute the Apple Software, with or without
				modifications, in source and/or binary forms; provided that if you redistribute
				the Apple Software in its entirety and without modifications, you must retain
				this notice and the following text and disclaimers in all such redistributions of
				the Apple Software.  Neither the name, trademarks, service marks or logos of
				Apple Computer, Inc. may be used to endorse or promote products derived from the
				Apple Software without specific prior written permission from Apple.  Except as
				expressly stated in this notice, no other rights or licenses, express or implied,
				are granted by Apple herein, including but not limited to any patent rights that
				may be infringed by your derivative works or by other works in which the Apple
				Software may be incorporated.

				The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
				WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
				WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
				PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
				COMBINATION WITH YOUR PRODUCTS.

				IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
				CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
				GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
				ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
				OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
				(INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
				ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
				
	Change History (most recent first):

	   <46>	 	08/30/00	srk		Carbonization

*/
#pragma once

/************************************************************
*                                                           *
*    INCLUDE FILES                                          *
*                                                           *
*************************************************************/

#include "main.h"

// Windows headers
#define	STRICT
#include <windows.h>

/************************************************************
*                                                           *
*    GLOBALS                                                *
*                                                           *
*************************************************************/

CGrafPtr gQTMLGraphicsPort = NULL;


/************************************************************
*                                                           *
*    FUNCTION PROTOTYPES                                    *
*                                                           *
*************************************************************/

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM) ;



/************************************************************
*                                                           *
*    WinMain()                                              *
*                                                           *
*                                                           *
*************************************************************/

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
     {
     static char szAppName[] = "DesktopSprites" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASSEX  wndclass ;
	 SpriteWorld theSpriteWorld = NULL;
	 RECT        currWinBounds;
	 Rect        spriteWindowBounds;
	 char        szAppPathName[256];
	 FSSpec	     resFSSpec;
	 short       appResID;



	 /* Initialize QuickTime Media Layer */
	if (!QTCode_DoQTInit())
	{
		return 0;
	}

	GetModuleFileName(0, szAppPathName, 256);
	NativePathNameToFSSpec(szAppPathName,&resFSSpec,kFullNativePath);
		/* open our resource fork so we can
			access our Mac-style program resources */
	appResID = FSpOpenResFile(&resFSSpec, fsRdPerm);

		/* quicktime cannot draw into our window until
			we've created a graphics port for it by 
			calling CreatePortAssociation - see our 
			WndProc procedure below where this is done */
	gQTMLGraphicsPort = NULL;

     wndclass.cbSize        = sizeof (wndclass) ;
     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;
     wndclass.hIconSm       = LoadIcon (NULL, IDI_APPLICATION) ;

     RegisterClassEx (&wndclass) ;

     hwnd = CreateWindow (szAppName,         // window class name
		            "Desktop Sprites",       // window caption
                    WS_OVERLAPPEDWINDOW,     // window style
                    CW_USEDEFAULT,           // initial x position
                    CW_USEDEFAULT,           // initial y position
                    CW_USEDEFAULT,           // initial x size
                    CW_USEDEFAULT,           // initial y size
                    NULL,                    // parent window handle
                    NULL,                    // window menu handle
                    hInstance,               // program instance handle
		            NULL) ;		             // creation parameters

     ShowWindow (hwnd, iCmdShow) ;
     UpdateWindow (hwnd) ;


	 if (GetWindowRect(hwnd, &currWinBounds))
	 {
		QTCode_MapWinRectToQTMLRect(&currWinBounds, &spriteWindowBounds);
	 }
	 else
	 {
		 spriteWindowBounds.top = 0;
		 spriteWindowBounds.left = 0;
		 spriteWindowBounds.bottom = 240;
		 spriteWindowBounds.right = 320;
	 }

		// Create our sprite world & sprites
	theSpriteWorld = QTSprites_CreateSpriteWorld (&spriteWindowBounds, (CGrafPtr)GetHWNDPort(hwnd));

	 while (GetMessage (&msg, NULL, 0, 0))
	{
		TranslateMessage (&msg) ;
		DispatchMessage (&msg) ;

			/* we'll do our drawing only if we have
				a valid qtml graphics port to draw into */
		if (gQTMLGraphicsPort)
		{
		  			// Animate the sprites
			QTSprites_MoveSprites();

			SpriteWorldIdle(theSpriteWorld,	/* the sprite world for this operation */
							0,				/* Contains flags describing actions that may take place during the idle. */
							0);				/* On return, contains a pointer to flags describing actions that
											took place during the idle. */
		}
	}

	QTSprites_DisposeSpriteWorld(theSpriteWorld);

		/* we're done accessing our Mac-style
			resources so we can close our
			resource file */
	if (appResID != -1)
		 CloseResFile(appResID);

	 		/* notify QTML */
	QTCode_QTCleanUp();

	 return msg.wParam ;
     }

/************************************************************
*                                                           *
*    WndProc()                                              *
*                                                           *
*    Standard Win32 Window Procedure                        *
*                                                           *
*    It's here we associate a QuickTime graphics port with  *
*    our window so QuickTime can draw into the window       *
*                                                           *
*************************************************************/

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
     {

     switch (iMsg)
      {
      case WM_CREATE :
		  {
			  /* create a qtml graphics port so qtml can draw into
					our Win32 window */
			gQTMLGraphicsPort = (CGrafPtr)QTCode_DoCreatePortAssociation(hwnd, NULL, 0L);
			
			return 0 ;
		  }

      case WM_CLOSE :
				/* Destroy the port association */
			QTCode_DoDestroyPortAssociation(hwnd);
			gQTMLGraphicsPort = NULL;

           PostQuitMessage (0) ;
           return 0 ;
      }

     return DefWindowProc (hwnd, iMsg, wParam, lParam) ;
     }
