/*
	File:		ImageCompressionUtilities.h
	
	Description: Include file for ImageCompressionUtilities.c

	Author:		QuickTime team

	Copyright: 	 Copyright 1999 Apple Computer, Inc. All rights reserved.
	
	Disclaimer:	IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
				("Apple") in consideration of your agreement to the following terms, and your
				use, installation, modification or redistribution of this Apple software
				constitutes acceptance of these terms.  If you do not agree with these terms,
				please do not use, install, modify or redistribute this Apple software.

				In consideration of your agreement to abide by the following terms, and subject
				to these terms, Apple grants you a personal, non-exclusive license, under Apples
				copyrights in this original Apple software (the "Apple Software"), to use,
				reproduce, modify and redistribute the Apple Software, with or without
				modifications, in source and/or binary forms; provided that if you redistribute
				the Apple Software in its entirety and without modifications, you must retain
				this notice and the following text and disclaimers in all such redistributions of
				the Apple Software.  Neither the name, trademarks, service marks or logos of
				Apple Computer, Inc. may be used to endorse or promote products derived from the
				Apple Software without specific prior written permission from Apple.  Except as
				expressly stated in this notice, no other rights or licenses, express or implied,
				are granted by Apple herein, including but not limited to any patent rights that
				may be infringed by your derivative works or by other works in which the Apple
				Software may be incorporated.

				The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
				WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
				WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
				PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
				COMBINATION WITH YOUR PRODUCTS.

				IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
				CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
				GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
				ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
				OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
				(INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
				ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
				
	Change History (most recent first):

	   <1>	 	08/30/00	srk		Carbonization

*/

#ifndef _IMAGECOMPRESSIONUTILITIES_
#define _IMAGECOMPRESSIONUTILITIES_

#ifndef __MOVIES__
#include <Movies.h>
#endif


// _____________________ Image Compression Utilities _____________________ //


// Given a QuickDraw picture, extract QuickTime compressed image data and description, if any
OSErr ExtractCompressData( PicHandle thePict, Handle *dataOut, ImageDescriptionHandle *idh );


// Utilities for compressing from various types of sources


OSErr RecompressCompressedImageWithTransparency( ImageDescriptionHandle originalDesc, Handle originalImageData,
													RGBColor *keyColor, 
													RgnHandle limitHitTestRegion,
													ImageDescriptionHandle *idh, Handle * imageData );
OSErr RecompressPictureWithTransparency ( PicHandle originalPicture,
													RGBColor *keyColor, 
													RgnHandle limitHitTestRegion,
													ImageDescriptionHandle *idh, Handle * imageData );
OSErr RecompressPictureFileWithTransparency ( FSSpec * spec, 
													RGBColor *keyColor, 
													RgnHandle limitHitTestRegion,
													ImageDescriptionHandle *idh, Handle * imageData );

// Low-level callback procedure based routine to compress with/without transparency & hit-testing

enum {
	kRecoProcInitMsg = 1,					// message and refcon are valid
	kRecoProcDisposeMsg = 2,				// message and refcon are valid
	kRecoProcGetBoundsMsg = 3,				// message, bounds and refcon are valid. Proc fills in bounds with rectangle to use for compressed image.
	kRecoProcDrawMsg = 4					// message, bounds, drawingPort, portType and refcon are valid. portType is 'imag' if drawing into
											// image GWorld, 'imap' if drawing into hit testing GWorld.
};

enum {
	kRecoProcOriginalImageType = 			FOUR_CHAR_CODE('imag'),
	kRecoProcHitTestingImageType = 			FOUR_CHAR_CODE('imap')
};

typedef pascal OSErr (*CompressDrawProc)( short message, Rect * bounds, GWorldPtr drawingPort, OSType drawingImageType, void * refcon );

OSErr RecompressWithTransparencyFromProc( CompressDrawProc drawProc, void * drawProcRefcon, 
													Boolean includeHitTesting,
													RGBColor *keyColor, 
													RgnHandle hitTestRegion,
													ImageDescriptionHandle *idh, Handle * imageData );

#endif
