/*
	File:		Open_URL.java
	
	Description:	This sample demonstrates two different techniques for searching for text strings 
                        in movie text media - the quicktime.std.movies.searchText method, and the 
                        quicktime.std.movies.media.TextMediaHandler.findNextText method.
                        
	Author:		Apple Computer, Inc.
        
	Copyright: 	 Copyright 2002 Apple Computer, Inc. All rights reserved.
	
	Disclaimer:	IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
				("Apple") in consideration of your agreement to the following terms, and your
				use, installation, modification or redistribution of this Apple software
				constitutes acceptance of these terms.  If you do not agree with these terms,
				please do not use, install, modify or redistribute this Apple software.
				In consideration of your agreement to abide by the following terms, and subject
				to these terms, Apple grants you a personal, non-exclusive license, under Apples
				copyrights in this original Apple software (the "Apple Software"), to use,
				reproduce, modify and redistribute the Apple Software, with or without
				modifications, in source and/or binary forms; provided that if you redistribute
				the Apple Software in its entirety and without modifications, you must retain
				this notice and the following text and disclaimers in all such redistributions of
				the Apple Software.  Neither the name, trademarks, service marks or logos of
				Apple Computer, Inc. may be used to endorse or promote products derived from the
				Apple Software without specific prior written permission from Apple.  Except as
				expressly stated in this notice, no other rights or licenses, express or implied,
				are granted by Apple herein, including but not limited to any patent rights that
				may be infringed by your derivative works or by other works in which the Apple
				Software may be incorporated.
				The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
				WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
				WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
				PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
				COMBINATION WITH YOUR PRODUCTS.
				IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
				CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
				GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
				ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
				OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
				(INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
				ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
				
	Change History (most recent first):
            11/22/2002	md	new SampleCode revisions
*/

import java.awt.*;
import java.awt.event.*;

public class Open_URL extends Dialog implements ActionListener {
	public Open_URL(MovieTextFinder parent) {
		super(parent, true);
		myPlayMovie = parent;
		
		setLayout(null);
		setResizable(false);
		setSize(452,126);
		setFont(new Font("Dialog", Font.PLAIN, 12));
		setBackground (new Color(12632256));
		label2 = new Label("URL:");
		label2.setBounds(18,48,29,18);
		add(label2);
		label1 = new Label ("Please type in an URL for to open:");
		label1.setBounds(54,15,370,23);
		add(label1);
		okButton = new Button();
		okButton.setLabel("OK");
		okButton.setBounds(368,94,60,23);
		add(okButton);
		cancelButton = new Button();
		cancelButton.setLabel("Cancel");
		cancelButton.setBounds(293,94,60,23);
		add(cancelButton);			
		urlTextField = new TextField("file:///... Enter an URL to a movie");
		urlTextField.setBounds(50,42,380,30);
		urlTextField.setFont(new Font("Dialog", Font.PLAIN, 10));

		add(urlTextField);
		setTitle("Open URL");
		
		urlTextField.addActionListener(this);
		cancelButton.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				dispose();
			}
		});
			
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				myPlayMovie.createNewMovieFromURL(urlTextField.getText());
				dispose();
			}
		});
	}
	
	public void addNotify()	{
  	    // Record the size of the window prior to calling parents addNotify.
	    Dimension d = getSize();

		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}

    // Used for addNotify check.
	boolean fComponentsAdjusted = false;

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b) {
		if(b) {
			Rectangle bounds = getParent().getBounds();
			Rectangle abounds = getBounds();
	
			setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
				 bounds.y + (bounds.height - abounds.height)/2);
		}
		super.setVisible(b);
	}

	Label label2;
	Label label1;
	Button okButton;
	Button cancelButton;
	TextField urlTextField;
	
	private MovieTextFinder myPlayMovie;

	public void actionPerformed(ActionEvent evt) {		
		myPlayMovie.createNewMovieFromURL (urlTextField.getText());
		dispose();
	}
}
