/*
	File:		KeyBoardController.java
	
	Description:	This demo program shows how to customise user control of the playback of a movie
                        that is a member of a Compositor using the Keyboard.

	Author:		Apple Computer, Inc.

	Copyright: 	 Copyright 2002 Apple Computer, Inc. All rights reserved.
	
	Disclaimer:	IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
				("Apple") in consideration of your agreement to the following terms, and your
				use, installation, modification or redistribution of this Apple software
				constitutes acceptance of these terms.  If you do not agree with these terms,
				please do not use, install, modify or redistribute this Apple software.

				In consideration of your agreement to abide by the following terms, and subject
				to these terms, Apple grants you a personal, non-exclusive license, under Apples
				copyrights in this original Apple software (the "Apple Software"), to use,
				reproduce, modify and redistribute the Apple Software, with or without
				modifications, in source and/or binary forms; provided that if you redistribute
				the Apple Software in its entirety and without modifications, you must retain
				this notice and the following text and disclaimers in all such redistributions of
				the Apple Software.  Neither the name, trademarks, service marks or logos of
				Apple Computer, Inc. may be used to endorse or promote products derived from the
				Apple Software without specific prior written permission from Apple.  Except as
				expressly stated in this notice, no other rights or licenses, express or implied,
				are granted by Apple herein, including but not limited to any patent rights that
				may be infringed by your derivative works or by other works in which the Apple
				Software may be incorporated.

				The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
				WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
				WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
				PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
				COMBINATION WITH YOUR PRODUCTS.

				IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
				CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
				GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
				ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
				OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
				(INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
				ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
				
	Change History (most recent first):
            11/22/2002	md	new SampleCode revisions

*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;

import quicktime.std.StdQTConstants;
import quicktime.*;
import quicktime.qd.*;
import quicktime.io.*;
import quicktime.std.image.*;
import quicktime.std.movies.*;

import quicktime.app.players.*;
import quicktime.app.QTFactory;
import quicktime.app.time.*;
import quicktime.app.image.*;
import quicktime.app.display.*;
import quicktime.app.anim.*;
import quicktime.app.spaces.*;
import quicktime.app.actions.*;


public class KeyBoardController extends Frame implements StdQTConstants, QDConstants {
	
	public static void main(String args[]) {
		try { 
			QTSession.open();
			
			KeyBoardController te = new KeyBoardController("KeyBoard Controller");
			te.pack();
			te.show();
			te.toFront();	
		} catch (Exception e) {
			e.printStackTrace();
			QTSession.close();
		}
	
	}
	
	KeyBoardController(String title) throws Exception {
		super (title);

		QTCanvas myQTCanvas = new QTCanvas(QTCanvas.kInitialSize, 0.5f, 0.5f);
		add("Center", myQTCanvas);
						
		addWindowListener(new WindowAdapter() {
			public void windowClosing (WindowEvent e) {
				QTSession.close();
				dispose();
			}
			
			public void windowClosed (WindowEvent e) { 
				System.exit(0);
			}
		});

		QDDimension dimension = new QDDimension (300, 300);
		QDGraphics gw = new QDGraphics (new QDRect(dimension));
		Compositor comp = new Compositor (gw, QDColor.gray, 20, 1);
		
		GraphicsImporterDrawer gid = new GraphicsImporterDrawer (new QTFile (QTFactory.findAbsolutePath ("pics/house.jpg")));
		gid.setDisplayBounds (new QDRect (dimension));
		ImagePresenter imgPresenter = ImagePresenter.fromGraphicsImporterDrawer (gid);
		imgPresenter.setGraphicsMode (new GraphicsMode (blend, QDColor.gray));
		comp.addMember (imgPresenter, 1);

		QTFile qtFile = new QTFile (QTFactory.findAbsolutePath ("jumps.mov"));		
		OpenMovieFile movieFile = OpenMovieFile.asRead(qtFile);
		Movie moov = Movie.fromFile (movieFile);
		MoviePresenter movPresenter = new MoviePresenter(moov);		
		movPresenter.setLocation (80, 80);
		comp.addMember (movPresenter, 2);

		KBDController keyController = new KBDController(movPresenter);				
		comp.addController(keyController);

		myQTCanvas.setClient (comp, true);
		comp.getTimer().setRate(1);
	}	
}


class KBDController implements ListenerController, KeyListener {

	private Playable player;
	private float savedRate = 1;
	KBDController (Playable player) {
		this.player = player;
	}
		
	public void addedToSpace (Space s) {}

	public void removedFromSpace () {}
		
	public void addedTo (Object interest){
		if (interest instanceof Component)
			((Component)interest).addKeyListener (this);	
	}	
	public void removedFrom (Object interest){
		if (interest instanceof Component)
			((Component)interest).removeKeyListener (this);	
	}
	public void keyPressed (KeyEvent e) {
		try {
			switch (e.getKeyCode()) {
				case KeyEvent.VK_SPACE:
					if (player.getRate() != 0) 
						player.setRate (0);
					else
						player.setRate (savedRate);
					break;
				case KeyEvent.VK_UP:
					player.setTime (player.getDuration());
					break;
				case KeyEvent.VK_DOWN:
					player.setTime (0);
					break;
				case KeyEvent.VK_LEFT:
					player.setRate (-1);
					savedRate = -1;
					break;
				case KeyEvent.VK_RIGHT:
					player.setRate (1);
					savedRate = 1;
					break;
			}
		} catch (QTException ee) {
			throw new QTRuntimeException (ee);
		}
	}
	public void keyReleased (KeyEvent e) {}
	public void keyTyped (KeyEvent e) {}
}	
	
