/*
	File:		MovieScreen.java
	
	Description:	This demo program shows how to display any QuickTime content within a java.awt display space using
                        the QTCanvas. It also demonstrates the use of the different resize options of the QTCanvas (with
                        the QTCanvas' alignment set to centre it in the display space).

	Author:		Apple Computer, Inc.

	Copyright: 	 Copyright 2002 Apple Computer, Inc. All rights reserved.
	
	Disclaimer:	IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
				("Apple") in consideration of your agreement to the following terms, and your
				use, installation, modification or redistribution of this Apple software
				constitutes acceptance of these terms.  If you do not agree with these terms,
				please do not use, install, modify or redistribute this Apple software.

				In consideration of your agreement to abide by the following terms, and subject
				to these terms, Apple grants you a personal, non-exclusive license, under Apples
				copyrights in this original Apple software (the "Apple Software"), to use,
				reproduce, modify and redistribute the Apple Software, with or without
				modifications, in source and/or binary forms; provided that if you redistribute
				the Apple Software in its entirety and without modifications, you must retain
				this notice and the following text and disclaimers in all such redistributions of
				the Apple Software.  Neither the name, trademarks, service marks or logos of
				Apple Computer, Inc. may be used to endorse or promote products derived from the
				Apple Software without specific prior written permission from Apple.  Except as
				expressly stated in this notice, no other rights or licenses, express or implied,
				are granted by Apple herein, including but not limited to any patent rights that
				may be infringed by your derivative works or by other works in which the Apple
				Software may be incorporated.

				The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
				WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
				WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
				PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
				COMBINATION WITH YOUR PRODUCTS.

				IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
				CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
				GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
				ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
				OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
				(INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
				ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
				
	Change History (most recent first):
            11/22/2002	md	new SampleCode revisions

*/

package duke;

import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import quicktime.QTException;
import quicktime.io.*;
import quicktime.std.movies.*;
import quicktime.app.players.*;
import quicktime.app.display.*;
import quicktime.app.image.*;
import quicktime.util.*;
import quicktime.app.QTFactory;
/**
 * This class is just used as a central location for the player, canvas and
 * controller, which are all set up via the getNewMovie method.
 */
public class MovieScreen {
//_________________________ CLASS METHODS
	public MovieScreen() throws QTException {
		canvas  = new QTCanvas(QTCanvas.kInitialSize, 0.5F, 0.5F);
		
		canvas.addQTClientListener (new ComponentAdapter () {
		    public void componentResized(ComponentEvent e) {
		    	System.out.println (e);
		    }
		    public void componentMoved(ComponentEvent e) {
		    	System.out.println (e);
		    }

		    public void componentShown(ComponentEvent e) {
		    	System.out.println (e);
		    }

		    public void componentHidden(ComponentEvent e) {
		    	System.out.println (e);
		    }
		});
		canvas.setClient (ImageDrawer.getQTLogo(), true);
	}
	
//_________________________ INSTANCE VARIABLES
	private QTCanvas canvas;
	private QTDrawable qtp = null;
	
//_________________________ INSTANCE METHODS
	/** Stops the player and removes it from the task thread*/
	public void stopPlayer () {
		try {
			if (qtp != null && qtp instanceof Playable)
				((Playable)qtp).setRate(0);
		} catch (QTException e) {}
	}

	/** Return the current QTCanvas. */
	public QTCanvas getCanvas() { return this.canvas; }
	
	public void startPlayer() {
		try {
			if (qtp != null && qtp instanceof Playable)
				((Playable)qtp).setRate(1);
		} catch (QTException e) {}
	}
	
	public void setLooping (boolean flag) {
		try {
			if (qtp != null && qtp instanceof Playable)
				((QTPlayer)qtp).getMovieController().setLooping(flag);	
		} catch (QTException e) {}
	}
	
	public boolean isLooping () {
		try {
			if (qtp != null && qtp instanceof Playable)
				return ((QTPlayer)qtp).getMovieController().getLooping();
		} catch (QTException e) {}
		return false;
	}

	/**
	 * Allow user to pick a new movie. Ordinarily, this method would return a
	 * boolean. But it returns the path string of the chosen movie so we know
	 * where to get the images for the tumbling duke animation.
	 */
	public void getNewMovie (QTFile qtf) throws QTException, IOException {
		stopPlayer();
		
		qtp = (QTFactory.makeDrawable(qtf));
		if (qtp instanceof QTPlayer)
			((QTPlayer)qtp).getMovieController().setKeysEnabled(true);
		
		// set the client of the current screen.
		canvas.setClient (qtp, true);
	}
}
