package ds.actions;

import quicktime.app.actions.*;
import quicktime.std.music.*;
import quicktime.*;

public class PlayNote implements Actionable, Runnable {
	public PlayNote (int noteNum, int duration, int gmNumber) throws QTException {
		nc = new NoteChannel (new NoteAllocator(), gmNumber);
		note = noteNum;
		dur = duration;
	}
	
	private int note, dur;
	private NoteChannel nc;
	private Thread thread = null;
	private long startTime;
	
	// action is ONLY triggered when the last instance of
	// this action has completed (when thread is reset to null)
	public void trigger () {
		if (nc == null) return;
		if (thread == null) {
			thread = new Thread(this);
			thread.start();
		}
	}
	
	public void run () {
		try {
			nc.playNote (note, 127);
			Thread.sleep (dur);
			nc.playNote (note, 0);
		} catch (Exception e) {
			throw new QTRuntimeException (e);
		}
		thread = null;
	}
}
