/*
 * QuickTime for Java SDK Sample Code

   Usage subject to restrictions in SDK License Agreement
 * Copyright:  1996-1999 Apple Computer, Inc.

 */
import java.io.File;
import java.awt.event.*;

import quicktime.*;
import quicktime.app.*;
import quicktime.qd.*;
import java.awt.*;
import quicktime.app.display.*;
import quicktime.std.*;
import quicktime.app.image.*;
import quicktime.io.QTFile;
import quicktime.util.*;
import quicktime.std.StdQTConstants;


public class CreatePictFile extends Frame implements StdQTConstants {

	Pict myPict;
	CreatePictFile cd;
	
	public static void main(String args[]) {		
		try {
			QTSession.open();
			CreatePictFile cd = new CreatePictFile();
			cd.show();
			cd.toFront();
		} catch (Exception e) {
			e.printStackTrace();
			QTSession.close();
		}
	}
	
	CreatePictFile () throws Exception {
		super ("QT in Java");
		addWindowListener(new WindowAdapter () {
			public void windowClosed(WindowEvent inEvent) {
				System.exit(0);
			}
				
			public void windowClosing(WindowEvent inEvent) {
				QTSession.close();
				dispose();
			}
		});
		QTCanvas myQTCanvas = new QTCanvas(QTCanvas.kAspectResize, 0, 0);
		add("Center", myQTCanvas);
					
		addNotify();
		Insets insets = getInsets();
		setBounds (0, 0, (insets.left + insets.right + 500), (insets.top + insets.bottom + 300));

		Button b = new Button ("Click here to create a PICT File of window's contents");
		b.addActionListener (new ActionListener () {
			public void actionPerformed (ActionEvent event) {
				try {
					myPict.writeToFile(new File("results.pict"));							
				} catch (Exception ex) { 
					ex.printStackTrace();
				}						
			}
		});
		
		add("North", b);
		
		int[] fileTypes = { kQTFileTypeGIF, kQTFileTypeJPEG, kQTFileTypePicture };
		QTFile qtf = QTFile.standardGetFilePreview (fileTypes);

		GraphicsImporterDrawer myImageFile = new GraphicsImporterDrawer (new QTFile(qtf));

		QDGraphics recordingGraphics = new QDGraphics (myImageFile.getDisplayBounds());
		myImageFile.setGWorld (recordingGraphics);
		
			//Note that the last 2 Parameters to OpenCPicParams represent the resolution in DPI - the default is 72
		OpenCPicParams param = new OpenCPicParams(myImageFile.getDisplayBounds());
			
			// whenever you draw to a QDGraphics from which
			// you are creating a PICT you MUST set
			// the GWorld first and retain it as the current 
			// GWorld whilst open, draw then close
		myPict = Pict.open (recordingGraphics, param);
		
			SetGWorld sg = new SetGWorld(recordingGraphics);
			myImageFile.redraw(null);
			sg.reset();
		
		myPict.close();
					
		ImagePresenter ip = ImagePresenter.fromPict (myPict);
		myQTCanvas.setClient (ip, true);
	}
}
