//////////
//
//	File:		QTSndTween.h
//
//	Contains:	Sound tweening support for QuickTime movies.
//
//	Written by:	Tim Monroe
//				based largely on the tween sample code in the QuickTime 2.5 Developers Guide.
//
//	Copyright:	 1998 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	04/10/98	rtm		first file; revised to personal coding style
//	   
//////////

#include <Movies.h>
#include <Endian.h>

#define kTweenTimeScale					600
#define k3DDuration						5000

// IDs for the various tween entries we want to use
#define kSoundTweenID					1

// function prototypes
OSErr						QTSndTween_AddTweenTrackToMovie (Movie theMovie);
OSErr						QTSndTween_AddTweenEntryToSample (QTAtomContainer theSample, QTAtomID theID, QTAtomType theType, void *theData, long theDataSize);
OSErr						QTSndTween_AddTweenEntryToInputMap (QTAtomContainer theInputMap, long theRefIndex, long theID, OSType theType, char *theName);
