

LRESULT CALLBACK ContainerWndProc(
                HWND hWnd,        
                UINT message,      
                WPARAM uParam,     
                LPARAM lParam)   
{
        int wmId, wmEvent;

        switch (message) 
		{
            case WM_COMMAND:

                wmId    = LOWORD(uParam);
                wmEvent = HIWORD(uParam);

                switch (wmId) 
				{
					default:
                        return (DefWindowProc(hWnd, message, uParam, lParam));
                }
                break;

			case WM_INITMENU:
				{
					InitFlagMenu();
				}
				break;

			case WM_CREATE:
				{
				RECT aWinRect;
				GetClientRect(hWnd, (LPRECT)&aWinRect);

				gViewer = Q3WinViewerNew (hWnd, &aWinRect, (unsigned long) kQ3ViewerDefault);

				if( gViewer == NULL )
					return -1;
				}
				break;

            case WM_DESTROY:  // message: window being destroyed
                PostQuitMessage(0);
                break;

			case WM_SIZE:
				{
				long width  = LOWORD(lParam);
                long height  = HIWORD(lParam);
				RECT rect;
				
				rect.top = 0;
				rect.left = 0;
				rect.right = width;
				rect.bottom = height;
				Q3WinViewerSetBounds (gViewer, &rect);
				}
				break;

			case WM_SETFOCUS:
				SetFocus( Q3WinViewerGetWindow( gViewer ) );
				break;

            default:          // Passes it on if unproccessed
                    return (DefWindowProc(hWnd, message, uParam, lParam));
        }
        return (0);
}