/*
	File:		Queue.h

	Contains:	QuickTime Streaming sample application.

	Written by:	Scott Kuechle

	Copyright:	 1998 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

	   <1>	 	11/20/98		srk		first file
	    
 
 NOTES:

 
 TO DO:

*/

#pragma once

/************************************************************
*                                                           *
*    INCLUDE FILES                                          *
*                                                           *
*************************************************************/

#include "QuickTimeStreaming.h"
#include "OSUtils.h"

/************************************************************
*                                                           *
*    CONSTANTS                                              *
*                                                           *
*************************************************************/

#define kQItems 10

/************************************************************
*                                                           *
*    STRUCTURES FOR THIS MODULE                             *
*                                                           *
*************************************************************/

struct MyQElemRec
{
		/* first comes the standard queue element structure */
	QElem q;
		/* next is our custom queue element data */
	short			windowType;		/* receive or stream window? (TRUE = receive window) */
	QTSPresentation presentation;	/* holds any new presentations */
};

typedef struct MyQElemRec MyQElemRec;
typedef MyQElemRec *MyQElemRecPtr;

/************************************************************
*                                                           *
*    FUNCTION PROTOTYPES                                    *
*                                                           *
*************************************************************/

void			Queue_InitQHdr(QHdrPtr qHdrPtr);
void			Queue_InitQHdr_(void);
void			Queue_InitQ(QHdrPtr qHdrPtr, MyQElemRec qElemPtr[], int qItems);
void			Queue_InitQ_(void);
MyQElemRecPtr	Queue_GetQElem(QHdrPtr qHdrPtr);
MyQElemRecPtr	Queue_GetUsedQElem(void);
MyQElemRecPtr	Queue_GetFreeQElem(void);
void			Queue_PutElemIntoUsedQueue(MyQElemRecPtr qElemPtr);
void			Queue_PutElemIntoFreeQueue(MyQElemRecPtr qElemPtr);
void			Queue_SetQElemPresValue(MyQElemRecPtr qElemPtr,
						   QTSPresentation presentation);
QTSPresentation Queue_GetQElemPresValue(MyQElemRecPtr qElemPtr);