//////////
//
//	File:		QTGraphImp.h
//
//	Contains:	Sample code for using QuickTime's graphic import routines.
//				This file is used for BOTH MacOS and Windows.
//
//	Written by:	Tim Monroe
//				Based loosely on the SimpleGIExample.c code written by Apple DTS.
//
//	Copyright:	 1998 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	04/14/98	rtm		first file
//	   
//////////

//////////
//
// header files
//
//////////

#include <ImageCompression.h>
#include <Movies.h>
#include <OSUtils.h>
#include <QuickTimeComponents.h>
#include <Script.h>
#include <StandardFile.h>

//////////
//
// compiler flags
//
//////////

// do we use a data-flushing procedure?
#define USE_FLUSH_PROC				1

//////////
//
// constants
//
//////////

#if USE_FLUSH_PROC
#define kBufferSize					codecMinimumDataSize
#else
#define kBufferSize					(500 * 1024)
#endif

#define kImageFileCreator			FOUR_CHAR_CODE('ogle')

#define kSaveImagePrompt			"Save compressed image as:"
#define kSaveImageFileName			"Untitled.jpg"


//////////
//
// function prototypes
//
//////////

void							QTGraphImp_PromptUserForImageFileAndDisplay (void);
void							QTGraphImp_PromptUserForDiskFileAndSaveCompressed (void);
void							QTGraphImp_SaveCompressedImage (GWorldPtr theWorld, FSSpec *theFile);
PASCAL_RTN OSErr				QTGraphImp_DataUnloadProc (Ptr theData, long theBytesNeeded, long theRefCon);
OSErr							QTGraphImp_ExportGWorldToFile (GWorldPtr theWorld, FSSpec *theFile, OSType theType);
OSErr							QTGraphImp_GetAvailableExportTypes (GraphicsImportComponent theImporter);
OSErr							QTGraphImp_ExportImageFile (GraphicsImportComponent theImporter);
