//////////
//
//	File:		VRMovies.h
//
//	Contains:	Support for QuickTime movie playback in VR nodes.
//
//	Written by:	Tim Monroe
//
//	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	12/11/96	rtm		first file 
//	   
//////////

// header files
#include "QTUtilities.h"
#include "QuickTimeVR.h"

#include "ComApplication.h"

// constants
#define kDefaultEmbMovieWidth		QTVRUtils_DegreesToRadians(40.0)
#define kColorPickerTextStringID	128

// function prototypes
ApplicationDataHdl					VRMoov_InitWindowData (WindowObject theWindowObject);
Boolean								VRMoov_GetEmbeddedMovie (WindowObject theWindowObject);
Boolean								VRMoov_LoadEmbeddedMovie (FSSpec *theMovieFile, WindowObject theWindowObject);
void								VRMoov_LoopEmbeddedMovie (Movie theMovie, GWorldPtr theGWorld);
void								VRMoov_DumpEmbeddedMovie (WindowObject theWindowObject);
OSErr								VRMoov_InstallBackBufferImagingProc (QTVRInstance theInstance, WindowObject theWindowObject);
PASCAL_RTN OSErr					VRMoov_BackBufferImagingProc (QTVRInstance theInstance, Rect *theRect, UInt16 theAreaIndex, UInt32 theFlagsIn, UInt32 *theFlagsOut, WindowObject theWindowObject);
float								VRMoov_GetEmbeddedMovieWidth (WindowObject theWindowObject);
void								VRMoov_SetEmbeddedMovieWidth (WindowObject theWindowObject, float theWidth);
void								VRMoov_GetEmbeddedMovieCenter (WindowObject theWindowObject, QTVRFloatPoint *theCenter);
void								VRMoov_SetEmbeddedMovieCenter (WindowObject theWindowObject, const QTVRFloatPoint *theCenter);
float								VRMoov_GetEmbeddedMovieScale (WindowObject theWindowObject);
void								VRMoov_SetEmbeddedMovieScale (WindowObject theWindowObject, float theScale);
void								VRMoov_GetEmbeddedMovieRect (WindowObject theWindowObject, Rect *theRect);
void								VRMoov_SetEmbeddedMovieRect (WindowObject theWindowObject, const Rect *theRect);
void								VRMoov_SetChromaColor (WindowObject theWindowObject);
PASCAL_RTN OSErr					VRMoov_CoverProc (Movie theMovie, RgnHandle theRegion, WindowObject theWindowObject);
PASCAL_RTN Boolean					VRMoov_ColorDialogEventFilter (EventRecord *theEvent);
void								VRMoov_SetVideoGraphicsMode (Movie theMovie, ApplicationDataHdl theAppData, Boolean theSetVGM);
short								VRMoov_GetVideoGraphicsPixelDepth (Movie theMovie);
