/*
	File:		EffectUtilities.h

	Contains:	Tween utilities to help you write effects components

	Written by:	Tom Dowdy

	Copyright:	 1997-1998 by Apple Computer, Inc., all rights reserved.
	
*/


typedef struct TweenContainerRecord
	{
	QTTweener				tween;
	Handle					tweenData;
	Boolean					readyToGo;
	Boolean					pad[3];
	} TweenContainerRecord;

typedef struct TweenGlobals
	{
	QTAtomContainer				parameters;
	QTAtomContainer				defaultParameters;
	Boolean						atLeastOneTweener;
	Boolean						pad[3];
	} TweenGlobals;

OSErr CreateTweenRecord(
			TweenGlobals *glob, 			// input: our globals
			TweenContainerRecord *pTween, 	// input/output: tween record to initialize
			OSType paramterType,			// input: where to find parameter (type)
			long parameterID,				// input: where to find parameter (ID)
			Size parameterSize, 			// input: size of parameters
			OSType dataType,				// input: type of tween, 0 for none
			void *startValue,				// input: pointer or start value of default (for long size, just the data)
			void *endValue,					// input: pointer or end value of default (for long size, just the data)
			TimeValue duration);			// input: duration of the tween
void DisposeTweenRecord(TweenContainerRecord *pTween);
OSErr InitializeTweenGlobals(TweenGlobals *pTweenGlobals, CodecDecompressParams *p);
void DisposeTweenGlobals(TweenGlobals *pTweenGlobals);
