#include "BltMacros.h"

// --------------------------------------------------------------------------------------

//
//	Code that draws our actual effect.  Note that this code is very slow. 
//  It is intended only as an example/placeholder for code you will write.
//  A good first optimization would be to replace the floating-point math
//  with fixed point.
//	
//	32 bit case. For explanation of what this function does, see the
// comments in the 16 bit case, above.
//
static void EffectFilter32(BlitGlobals *glob);
static void EffectFilter32(BlitGlobals *glob)
{
	long height = glob->height;
	long *srcA = glob->sources[0].srcBaseAddr;
	long *srcB = glob->sources[1].srcBaseAddr;
	long *dst = glob->dstBaseAddr;
	long srcABump = glob->sources[0].srcRowBytes - (glob->width * 4);
	long srcBBump = glob->sources[1].srcRowBytes - (glob->width * 4);
	long dstBump = glob->dstRowBytes - (glob->width * 4);

	float	dimMultiple;
	
	if (glob->direction)
		dimMultiple = 1.0 - ((float) glob->dimValue) / 255;
	else
		dimMultiple = ((float) glob->dimValue) / 255;
		
	while (height--)
	{
		long width = glob->width;

		while (width--)
		{
			UInt32 	thePixelValue;
			UInt8	pixels[4];
			
			if (glob->direction)
			{
				thePixelValue = Get32(srcA);
				srcA++;
			}
			else
			{
				thePixelValue = Get32(srcB);
				srcB++;
			}
			// Convert the pixel format
			cnv32SPFto32AR(thePixelValue);
			
			// extract alpha, red, green, and blue from pixel
			pixels[0] = thePixelValue >> 24;
			pixels[1] = (thePixelValue >> 16) & 0xff;
			pixels[2] = (thePixelValue >> 8) & 0xff;
			pixels[3] = (thePixelValue >> 0) & 0xff;
			
			// Dim all of the RGB values by the same amount, but leave alpha alone
			pixels[1] = pixels[1] * dimMultiple;
			pixels[2] = pixels[2] * dimMultiple;
			pixels[3] = pixels[3] * dimMultiple;
			
			thePixelValue = (pixels[0] << 24) | (pixels[1] << 16) | (pixels[2] << 8) | (pixels[3]);
				
			cnv32ARto32DPF(thePixelValue);
			Set32(dst,thePixelValue);
			dst++;
		}

		if (glob->direction)
			srcA = (void *) (((Ptr) srcA) + srcABump);
		else
			srcB = (void *) (((Ptr) srcB) + srcBBump);
			
		dst = (void *) (((Ptr) dst) + dstBump);
	}
	
} // DrawEffectFrameEffect32Bit
