/*
	File:		Effect.r

	Copyright:	 1997-1998 by Apple Computer, Inc., all rights reserved.

*/

#define UseExtendedThingResource 1

#include "Components.r"
#include "ImageCodec.r"
#include "MacTypes.r"
#include "Icons.r"

#include "EffectDefinitions.h"

#if	TARGET_OS_WIN32
	#define Target_PlatformType      platformWin32
#endif


#define effectCodecInfo			"Dimmer Effect CodecInfo"

#define	effectCodecFormatName	"Dimmer Effect"

#define	effectCodecFormatType	'dimt'

#define DecoFlags		(codecInfoDoes32 + codecInfoDoes16 + codecInfoDoes8 + codecInfoDoes4 + codecInfoDoes2 + codecInfoDoes1 + codecInfoDoesSpool  + codecInfoHasEffectParameterList)
#define DataFormatFlags	(codecInfoDepth1 + codecInfoDepth2 + codecInfoDepth4 + codecInfoDepth8 + codecInfoDepth16 + codecInfoDepth32 + codecInfoDepth33 + codecInfoDepth34 + codecInfoDepth36 + codecInfoDepth40 + codecInfoDoesLossless)

/*

	This structure defines the capabilities of the codec. 
	
*/
resource 'cdci' (kEffectcdciRes, effectCodecInfo, locked) {
	effectCodecFormatName,							/* name of the codec TYPE ( data format ) */
	1,												/* version */							
	1,												/* revision */	
	'appl',											/* who made this codec */
	DecoFlags,										/* depth and etc. supported directly on decompress */	
	0,												/* depth and etc supported directly on compress */
	DataFormatFlags,								/* which data formats do we understand */
	100,											/* compress accuracy (0-255) (relative to format) */
	100,											/* decompress accuracy (0-255) (relative to format) */
	100,											/* millisecs to compress 320x240 image on base Mac */
	100,											/* millisecs to decompress 320x240 image on base Mac */
	100,											/* compression level (0-255) (relative to format) */
	0,								
	2,												/* minimum height */
	2,												/* minimum width */
	0,
	0,
	0
};

// ====================================================================================
// The Thing resources
// ====================================================================================

resource 'thng' (kEffectthngRes, "Dimmer2 Effect", locked) {
	decompressorComponentType,						// Type: always 'imdc' for effects
	effectCodecFormatType,							// SubType: the effect algorithm being implemented
	'appl',											// Manufacturer
	
	// The flags depend on the type of resource being built
#if	TARGET_REZ_MAC_68K
	DecoFlags,										// Flags
	0,												// Flags Mask
	'imdc', kEffectthngRes,							// Code resource
#else
	0, 0,											// Flags, Mask
	0, 0,											// Code resource
#endif
	'STR ',	kEffectNameRes,							// Name
	'STR ',	kEffectDescriptionRes,					// Info
	'ICON',	kEffectICONRes,							// Icon
	kDimmerEffectVersion,							// Version
	
#if !TARGET_REZ_MAC_68K
	componentHasMultiplePlatforms + 
#endif
		componentDoAutoVersion,
	0,												// Icon Family
	{
#if	TARGET_OS_MAC
  #if TARGET_REZ_MAC_PPC
		 DecoFlags, 
		'imdc',	kEffectthngRes,						// Code
		platformPowerPC,
  #endif
#else
		DecoFlags,				
		'dlle',	kEffectthngRes,						// Code
		Target_PlatformType,
#endif
	},
};


// ====================================================================================
// The component's icon
// ====================================================================================

resource 'ICON' (kEffectICONRes, purgeable) {
	$"0200 0F80 03FF FF80 0C00 0FE0 0FFF FFE0"
	$"0180 1F00 0100 0F00 0100 0F00 0300 0F80"
	$"0008 6000 0018 7000 007F FC00 00C0 1E00"
	$"0004 C000 0004 C000 0004 C000 0007 C000"
	$"0004 C000 0004 C000 0004 C000 0004 C000"
	$"0004 C000 0004 C000 0004 C000 0004 C000"
	$"0004 C000 0004 C000 0004 C000 0004 C000"
	$"0003 8000 0004 C000 0004 C000 0004 C000"
};


// ====================================================================================
// Name and description strings
// ====================================================================================

resource 'STR ' (kEffectNameRes) {
	"Dimmer2 Effect"
};

resource 'STR ' (kEffectDescriptionRes) {
	"Fades down from one source, then fades up on a second source"
};

// ====================================================================================
// The parameter descriptions
// You must change these to reflect the paramaters that your effect takes.
// Each effect has a set of standard resources that must be present.
// A set of optional resources is required for each parameter your effect has.
// ====================================================================================

resource 'atms' (kEffectatmsRes) {
8 + 6,		// number of root atoms
{
	// ---------------------------------------
	// The Standard Resources
	// These must be present - they describe
	// your effect
	// ---------------------------------------
	
	// The name of the parameters
	kParameterTitleName, kParameterTitleID, noChildren,
	{
		string { "Dimmer2 Effect Parameters" };
	};
	
	// The name (subType) of the effect component
	kParameterWhatName, kParameterWhatID, noChildren,
	{
		OSType { "dimt" };
	};

	// The maximum number of sources the effect takes
	kParameterSourceCountName, kParameterSourceCountID, noChildren,
	{
		long { "2" };
	};
	
	// If this codec can't be found, try this other one as a replacement
	kParameterAlternateCodecName, kParameterAlternateCodecID, noChildren,
	{
		OSType { "dslv" };
	};
	
	// Information atoms
	kParameterInfoLongName, kParameterInfoIDs, noChildren,
	{
		string { "Dimmer2 Effect" };
	};
	
	kParameterInfoCopyright, kParameterInfoIDs, noChildren,
	{
		string { "Sample QuickTime Effect by Apple Computer, Inc." };
	};
	
	kParameterInfoDescription, kParameterInfoIDs, noChildren,
	{
		string { "Fades down from one source, then fades up on a second source." };
	};
	
	kParameterInfoWindowTitle, kParameterInfoIDs, noChildren,
	{
		string { "Dimmer2 Effect Information" };
	};
	
	// ---------------------------------------
	// Optional Resources
	// There is a standard set of resources
	// for each parameter your effect takes.
	// See the QT3.0
	// SDK chapter on effects for descriptions
	// of the resources you must supply for
	// your effect
	// ---------------------------------------

	// The percentage parameter defines the starting and end
	// point of the effect. For example, instead of fading down
	// from full intensity to black, then up again, you could
	// fade down from a medium intensity, then back up to full
	// intensity by specifying a starting percentage of 25% and
	// an ending percentage of 100%
	
	// The general information about the parameter
	kParameterAtomTypeAndID, 1, noChildren,
	{
		OSType { "pcnt" };				// The parameter code
		long { "1" };					// The parameter ID
		kAtomNoFlags;					// Parameter flags
		string { "Percentage" };		// The parameter name
	};
	
	// The data type of the parameter
	kParameterDataType, 1, noChildren,
	{
		kParameterTypeDataFixed;
	};
	
	// The range of values the parameter can take			
	kParameterDataRange, 1, noChildren,
	{
		long { "0" };			// Minimum value
		long { "65536" };		// Maximum value
		long { "6553600" };		// Scale. This value will scale the value set
								// by the user into the range 0100
		long { "0" };			// Precision
	};

	// The parameter's "behavior"
	kParameterDataBehavior, 1, noChildren,
	{
		kParameterItemControl;	// Display this item using a control. In the case
								// of a parameter of data type Fixed, this will result
								// (in the standard parameters dialog box) in a slider
								// being displayed which the user can use to set the
								// value of the parameter.
		long { "0" };			// Flags
	};

	// How the parameter's value will be used.
	kParameterDataUsage, 1, noChildren,
	{
		kParameterUsagePercent;	// The parameter stores a percentage
	};
	
	// The default value for the parameter. In this case this
	// is a tween record	
	kParameterDataDefaultItem, 1, 2,
	{
	};
		// The tween record
		'twnt', 1, noChildren,
		{
			kParameterTypeDataFixed;	// This is a fixed-point tween
		};
		'data', 1, noChildren,
		{
			long { "0" };				// The default lower value (0%)
			long { "65536" };			// The default upper value (100%)
		};
};
};

#ifndef MW_REZ

#if	TARGET_OS_MAC
	#if TARGET_REZ_MAC_PPC
		read 'imdc' (kEffectthngRes, "Dimmer2 Effect") $$Shell("RsrcDir")"Dimmer2PPC.pef";
	#else
		Include $$Shell("RsrcDir")"Dimmer2Effect.rsrc" 'proc' (0) as 'imdc' ( kEffectthngRes, "Dimmer2 Effect" );
	#endif
#else
	resource 'dlle' (kEffectthngRes) {
		"EffectsFrameComponentDispatch"
	};
#endif

#endif // MW_REZ
