//////////
//
//	File:		QTText.c
//
//	Contains:	QuickTime text media handler sample code.
//
//	Written by:	Tim Monroe
//				parts based on QTTextSample code by Nick Thompson (see develop, issue 20).
//
//	Copyright:	 1995-1998 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	11/14/97	rtm		first file; conversion to personal coding style
//	   
//////////

//////////
//
// header files
//
//////////

#ifndef __FIXMATH__
#include <FixMath.h>
#endif

#ifndef __MOVIES__
#include <Movies.h>
#endif

#ifndef __SCRIPT__
#include <Script.h>
#endif

#ifndef __STANDARDFILE__
#include <StandardFile.h>
#endif

#include "ComApplication.h"

#if TARGET_OS_MAC
#include "MacFramework.h"
#endif

#if TARGET_OS_WIN32
#include "WinFramework.h"
#endif


//////////
//
// compiler flags
//
//////////

#define USE_MOVIESEARCHTEXT		1		// do we use MovieSearchText or TextMediaFindNextText to find text?


//////////
//
// constants
//
//////////

#define kAllTextTracks			0		// special index value to be passed to QTText_RemoveIndTextTrack
#define kTextTrackHeight		20		// default height (in pixels) of the new text track

#define kSearchText				"QuickTime"
#define kSampleText				""


//////////
//
// function prototypes
//
//////////

ApplicationDataHdl			QTText_InitWindowData (WindowObject theWindowObject);
void						QTText_DumpWindowData (WindowObject theWindowObject);
void						QTText_SetSearchText (void);
void						QTText_FindText (WindowObject theWindowObject, Str255 theText);
void						QTText_EditText (WindowObject theWindowObject);
PASCAL_RTN OSErr			QTText_TextProc (Handle theText, Movie theMovie, short *theDisplayFlag, long theRefCon);
Track						QTText_AddTextTrack (Movie theMovie, char *theStrings[], short theFrames[], short theNumFrames, OSType theType, Boolean isChapterTrack);
OSErr						QTText_RemoveIndTextTrack (Movie theMovie, short theIndex);
Boolean						QTText_TrackTypeHasAChapterTrack (Movie theMovie, OSType theType);
OSErr						QTText_SetTextTrackAsChapterTrack (WindowObject theWindowObject, OSType theType, Boolean isChapterTrack);
void						QTText_CopyCStringToPascal (const char *theSrc, Str255 theDst);
void						QTText_UpdateMovieAndController (MovieController theMC);
