//////////
//
//	File:		WiredSpriteUtilities.h
//
//	Contains:	Utilities for creating wired sprite media.
//
//	Written by:	Sean Allen
//	Revised by:	Chris Flick and Tim Monroe
//
//	Copyright:	 1998 by Apple Computer, Inc., all rights reserved.
//
//////////

#include <Endian.h>

#ifndef _WIREDSPRITEUTILITIES_
#define _WIREDSPRITEUTILITIES_
#ifndef __MOVIES__
	#include <Movies.h>
#endif
#endif

// _____________________ Action Sprite Utilities _____________________ //

OSErr AddQTEventAtom( QTAtomContainer container, QTAtom actionAtoms, QTAtomID theQTEventType, QTAtom *newQTEventAtom );
OSErr AddActionAtom( QTAtomContainer container, QTAtom eventAtom, long whichActionConstant, QTAtom *newActionAtom );
OSErr AddActionParameterAtom( QTAtomContainer container, QTAtom actionAtom, long parameterIndex, long paramDataSize, void *paramData, QTAtom *newParamAtom );
OSErr AddActionParameterOptions( QTAtomContainer container, QTAtom actionAtom, QTAtomID paramID, long flags, long minValueSize, void *minValue, long maxValueSize, void *maxValue );
OSErr AddTrackNameActionTargetAtom( QTAtomContainer container, QTAtom actionAtom, Str255 trackName, QTAtom *newTargetAtom );
OSErr AddTrackIDActionTargetAtom( QTAtomContainer container, QTAtom actionAtom, long trackID, QTAtom *newTargetAtom );
OSErr AddTrackTypeActionTargetAtom( QTAtomContainer container, QTAtom actionAtom, OSType trackType, QTAtom *newTargetAtom );
OSErr AddTrackIndexActionTargetAtom( QTAtomContainer container, QTAtom actionAtom, long trackIndex, QTAtom *newTargetAtom );
OSErr AddSpriteNameActionTargetAtom( QTAtomContainer container, QTAtom actionAtom, Str255 spriteName, QTAtom *newTargetAtom );
OSErr AddSpriteIDActionTargetAtom( QTAtomContainer container, QTAtom actionAtom, QTAtomID spriteID, QTAtom *newTargetAtom );
OSErr AddSpriteIndexActionTargetAtom( QTAtomContainer container, QTAtom actionAtom, short spriteIndex, QTAtom *newTargetAtom );


enum {
	kFirstParam		= 1,
	kSecondParam	= 2,
	kThirdParam		= 3,
	kFourthParam	= 4,
	kFifthParam		= 5,
	kSixthParam		= 6,
	kSeventhParam	= 7,
	kEighthParam	= 8,
	kNinthParam		= 9,
	kTenthParam		= 10
};

OSErr AddQTEventAndActionAtoms( QTAtomContainer container, QTAtom atom, long whichEvent, long whichAction, QTAtom *actionAtom );
OSErr AddTrackTargetAtom( QTAtomContainer container, QTAtom actionAtom, long trackTargetType, void *trackTarget, long trackTypeIndex );
OSErr AddSpriteTargetAtom( QTAtomContainer container, QTAtom actionAtom, long spriteTargetType, void *spriteTarget );
OSErr AddTrackAndSpriteTargetAtoms( QTAtomContainer container, QTAtom actionAtom, long trackTargetType, void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget );

OSErr AddMovieSetVolumeAction( QTAtomContainer container, QTAtom atom, long whichEvent, short volume );
OSErr AddMovieSetRateAction( QTAtomContainer container, QTAtom atom, long whichEvent, Fixed rate );
OSErr AddMovieSetLoopingFlagsAction( QTAtomContainer container, QTAtom atom, long whichEvent, long loopingFlags );
OSErr AddMovieGoToTimeAction( QTAtomContainer container, QTAtom atom, long whichEvent, TimeValue time );
OSErr AddMovieGoToTimeByNameAction( QTAtomContainer container, QTAtom atom, long whichEvent, Str255 timeName );
OSErr AddMovieGoToBeginningAction( QTAtomContainer container, QTAtom atom, long whichEvent );
OSErr AddMovieGoToEndAction( QTAtomContainer container, QTAtom atom, long whichEvent );
OSErr AddMovieStepForwardAction( QTAtomContainer container, QTAtom atom, long whichEvent );
OSErr AddMovieStepBackwardAction( QTAtomContainer container, QTAtom atom, long whichEvent );
OSErr AddMovieSetSelectionAction( QTAtomContainer container, QTAtom atom, long whichEvent, TimeValue startTime, TimeValue endTime );
OSErr AddMovieSetSelectionByNameAction( QTAtomContainer container, QTAtom atom, long whichEvent, Str255 startTimeName, Str255 endTimeName );
OSErr AddMoviePlaySelectionAction( QTAtomContainer container, QTAtom atom, long whichEvent, Boolean selectionOnly );
OSErr AddMovieSetLanguage( QTAtomContainer container, QTAtom atom, long whichEvent, long language );

OSErr AddTrackSetVolumeAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, short volume );
OSErr AddTrackSetBalanceAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, short balance );
OSErr AddTrackSetEnabledAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, Boolean enabled );
OSErr AddTrackSetMatrixAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, MatrixRecordPtr matrix, QTAtom *actionAtom );
OSErr AddTrackSetLayerAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, short layer );
OSErr AddTrackSetClipAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, RgnHandle clip );

OSErr AddSpriteSetMatrixAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, MatrixRecordPtr matrix, QTAtom *actionAtom );
OSErr AddSpriteSetImageIndexAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, short setImageIndex, QTAtom *actionAtom );
OSErr AddSpriteSetVisibleAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, short visible, QTAtom *actionAtom );
OSErr AddSpriteSetLayerAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, short layer );
OSErr AddSpriteSetGraphicsModeAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, 
								      void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, 
								      ModifierTrackGraphicsModeRecord *graphicsMode, QTAtom *actionAtom );

OSErr AddSpriteTranslateAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, 
								      void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, 
								      Fixed x, Fixed y, Boolean isRelative, QTAtom *actionAtom );
OSErr AddSpriteScaleAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, 
							void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, 
							Fixed xScale, Fixed yScale, Fixed aboutX, Fixed aboutY, Boolean isRelative, QTAtom *actionAtom );
OSErr AddSpriteRotateAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, 
							void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, 
							Fixed degrees, Fixed aboutX, Fixed aboutY, Boolean isRelative, QTAtom *actionAtom );
OSErr AddSpriteStretchAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, 
							void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget, 
							Fixed p1x, Fixed p1y, Fixed p2x, Fixed p2y, Fixed p3x, Fixed p3y, Fixed p4x, Fixed p4y, 
							Boolean isRelative, QTAtom *actionAtom );

OSErr AddMusicPlayNoteAction( QTAtomContainer container, QTAtom atom, long whichEvent, long trackTargetType, 
						      void *trackTarget, long trackTypeIndex, long sampleDescIndex, long partIndex,
						      long pitch, long velocity, long duration );

OSErr AddSpriteTrackSetVariableAction( QTAtomContainer container, QTAtom atom, long whichEvent, QTAtomID variableID, float value, 
									   long trackTargetType, void *trackTarget, long trackTypeIndex );

OSErr AddGoToURLAction( QTAtomContainer container, QTAtom atom, long whichEvent, Handle urlLink );
OSErr AddSendQTEventAction( QTAtomContainer container, QTAtom atom, long whichEvent, QTEventRecordPtr theEvent,
							long trackTargetType, void *trackTarget, long trackTypeIndex, long spriteTargetType, void *spriteTarget );
OSErr AddDebugStrAction( QTAtomContainer container, QTAtom atom, long whichEvent, Str255 theString );

OSErr AddPushCurrentTimeAction( QTAtomContainer container, QTAtom atom, long whichEvent );
OSErr AddPushCurrentTimeWithLabelAction( QTAtomContainer container, QTAtom atom, long whichEvent, Str255 theLabel );
OSErr AddPopAndGotoTopTimeAction( QTAtomContainer container, QTAtom atom, long whichEvent );
OSErr AddPopAndGotoLabeledTimeAction( QTAtomContainer container, QTAtom atom, long whichEvent, Str255 theLabel );

OSErr AddApplicationNumberAndStringAction( QTAtomContainer container, QTAtom atom, long whichEvent, long theNumber, Str255 theString );

// ________ Interpreted Actions __________

OSErr AddOperandAtom( QTAtomContainer container, QTAtom operatorAtom, QTAtomType operandType, short operandIndex,
					  QTAtomContainer operandAtoms, float constantValue );

OSErr AddVariableOperandAtom( QTAtomContainer container, QTAtom operatorAtom, short operandIndex,
					  		  long trackTargetType, void *trackTarget, long trackTypeIndex, QTAtomID variableID );

OSErr AddOperatorAtom( QTAtomContainer container, QTAtom expressionAtom, QTAtomID theOperatorType, QTAtom *operatorAtom );
OSErr AddExpressionContainerAtomType( QTAtomContainer container, QTAtom atom, QTAtom *expressionAtom );
OSErr AddConditionalAtom( QTAtomContainer container, QTAtom atom, short conditionIndex, QTAtom *conditionalAtom );
OSErr AddActionListAtom( QTAtomContainer container, QTAtom atom, QTAtom *actionListAtom );
void ConvertFloatToBigEndian (float *theFloat);


