//////////
//
//	File:		QTSprites.c
//
//	Contains:	QuickTime sprites support for QuickTime movies.
//				This file is used for BOTH MacOS and Windows.
//
//	Written by:	???
//	Revised by:	Tim Monroe and Deeje Cooley
//				Based (heavily!) on the existing MakeSpriteMovie.c code written by ???.
//
//	Copyright:	 1997-1998 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	04/02/98	rtm		first file; integrated existing code with shell framework
//	   
//////////

#include <Endian.h>
#include <FixMath.h>
#include <Fonts.h>
#include <Movies.h>
#include <Processes.h>
#include <QuickTimeComponents.h>
#include <Resources.h>
#include <Script.h>

#ifndef _SPRITEUTILITIES_
#include "SpriteUtilities.h"
#endif

#ifndef __ENDIANUTILITIES__
#include "EndianUtilities.h"
#endif

#include "ComApplication.h"

#if TARGET_OS_MAC
#include "MacFramework.h"
#endif

#if TARGET_OS_WIN32
#include "WinFramework.h"
#endif

#define kSpriteTrackWidth					640
#define kSpriteTrackHeight					480

// PICT resource IDs
#define kIconPictID							129
#define kWorldPictID						130
#define kBackgroundPictID					158
#define kFirstSpaceShipPictID				(kBackgroundPictID + 1)

// sprite atom IDs
#define kBackgroundSpriteAtomID				1
#define kSpaceShipSpriteAtomID				2
#define kWorldSpriteAtomID					3
#define kIconSpriteAtomID					4

// image indices
#define kIconImageIndex						1
#define kWorldImageIndex					2
#define kBackgroundImageIndex				3
#define kFirstSpaceShipImageIndex			4
#define kNumSpaceShipImages					24
#define kLastSpaceShipImageIndex			(kFirstSpaceShipImageIndex + kNumSpaceShipImages - 1)

#define kSpriteMediaTimeScale				600
#define kSpriteMediaFrameDuration			8
#define kSpriteMediaFramesPerSecond			(kSpriteMediaTimeScale / kSpriteMediaFrameDuration)

#define kNumOverrideSamples					199

// function prototypes
ApplicationDataHdl				QTSprites_InitWindowData (WindowObject theWindowObject);
void							QTSprites_DumpWindowData (WindowObject theWindowObject);
OSErr							QTSprites_CreateSpritesMovie (void);
Boolean							QTSprites_HitTestSprites (WindowObject theWindowObject, EventRecord *theEvent);
