/*
	File:		QTCode.h

	Contains:	QuickTime Streaming sample application.

	Written by:	Scott Kuechle

	Copyright:	 1998 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

	   <1>	 	11/20/98		srk		first file
	    
 
 NOTES:

 
 TO DO:

*/

/************************************************************
*                                                           *
*    INCLUDE FILES                                          *
*                                                           *
*************************************************************/

#include "Application.h"


/************************************************************
*                                                           *
*    FUNCTION PROTOTYPES                                    *
*                                                           *
*************************************************************/

GrafPtr		QTCode_DoCreatePortAssociation(void *theWnd, Ptr storage, long 	flags);
void		QTCode_DoDestroyPortAssociation(HWND hwnd);
OSErr		QTCode_DoQTInit();
void		QTCode_QTCleanUp();

OSErr QTCode_NewPresFromFile(char				*filePath,			/* sdp file path */
							 QTSPresentation	*aPresentation);	/* return presentation value here */
OSErr QTCode_ConfigurePresentation(QTSPresentation	aPresentation,
								  QTSStream			theStream,
								  CGrafPtr			aWindow);
OSErr QTCode_DestroyPresentation(QTSPresentation	aPresentation,
								QTSStream		theStream);
void QTCode_UpdatePresentation(QTSPresentation	aPresentation);
ComponentResult QTCode_NotificationProc(ComponentResult inErr,
										OSType			inNotificationType,
										void			*inNotificationParams,
										UInt32			inRefCon);
void Streaming_HandlePrerollAck(QTSPresentation aPresentation,
								QTSStream		theStream);

/************************************************************
*                                                           *
*    CONSTANTS                                              *
*                                                           *
*************************************************************/

#define	kPresWidth		160
#define	kPresHeight		120
