
#include "ContainerWindow.h"
#include "3dshell.h"
#include "resource.h"

#include "QD3DWinViewer.h"

TQ3ViewerObject containerViewer = NULL;

LRESULT CALLBACK ContainerWndProc(HWND hWnd, UINT message, WPARAM uParam,LPARAM lParam);

BOOL InitContainerWindowClass (HINSTANCE hInstance)
{
        WNDCLASS  wc;
        
		wc.style         = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc   = (WNDPROC)ContainerWndProc;       
        wc.cbClsExtra    = 0;                      
        wc.cbWndExtra    = 0;                     
        wc.hInstance     = hInstance;             
        wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE(IDI_APP)); 
        wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
        wc.lpszMenuName  = MAKEINTRESOURCE(IDR_CONTAINERMENU); 
		wc.lpszClassName = kContainerWindowClass;              
		
        return (RegisterClass(&wc));
}

LRESULT CALLBACK ContainerWndProc(
                HWND window,        
                UINT message,      
                WPARAM uParam,     
                LPARAM lParam)   
{
        int wmId, wmEvent;

        switch (message) 
		{
            case WM_COMMAND:

                wmId    = LOWORD(uParam);
                wmEvent = HIWORD(uParam);

                switch (wmId) 
				{

				case IDM_NEWVIEWER:
					break;

				case IDM_EXIT:
					PostQuitMessage (0);
					break;

					default:
                        return (DefWindowProc(window, message, uParam, lParam));
                }
                break;

			case WM_INITMENU:
				{
//					InitFlagMenu();
				}
				break;

			case WM_CREATE:
				{
				RECT aWinRect;
				
				GetClientRect(window, (LPRECT)&aWinRect);

				aWinRect.top += 100;
				aWinRect.bottom -= 100;
				aWinRect.left += 100;
				aWinRect.right -= 100;

				containerViewer = Q3WinViewerNew (window, &aWinRect, (unsigned long) kQ3ViewerDefault | WS_BORDER | WS_CAPTION | WS_THICKFRAME);

				if( containerViewer == NULL )
					return -1;
				}

				BringWindowToTop (Q3WinViewerGetWindow (containerViewer));
				break;

            case WM_DESTROY:  // message: window being destroyed
				Q3WinViewerDispose (containerViewer);
                PostQuitMessage(0);
                break;

				/*
			case WM_SIZE:
				{
				long width  = LOWORD(lParam);
               long height  = HIWORD(lParam);
				RECT rect;
				
				rect.top = 0;
				rect.left = 0;
				rect.right = width;
				rect.bottom = height;
			//	Q3WinViewerSetBounds (gViewer, &rect);
				}
				break;
			*/

			//case WM_SETFOCUS:
			//	SetFocus( Q3WinViewerGetWindow( gViewer ) );
			//	break;

            default:          // Passes it on if unproccessed
                    return (DefWindowProc(window, message, uParam, lParam));
        }
        return (0);
}